/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.pluggable;

import java.io.File;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import oracle.cluster.sql.DBConnectionException;
import oracle.cluster.sql.SQLFactory;
import oracle.cluster.verification.VerificationMessage;
import oracle.cluster.verification.VerificationMessageType;
import oracle.cluster.verification.pluggable.ArgType;
import oracle.cluster.verification.pluggable.DarwinPluggableTaskUtil;
import oracle.cluster.verification.pluggable.ExecutableArgument;
import oracle.cluster.verification.pluggable.ExecutableInfo;
import oracle.cluster.verification.pluggable.ExecutableType;
import oracle.cluster.verification.pluggable.PluggableMsgType;
import oracle.cluster.verification.pluggable.VerificationExecutableException;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.rowset.OracleCachedRowSet;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.RunExeCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.resources.PrveMsgID;

public class PluggableTaskUtil {
    protected static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prve");
    static final String LSEP = System.getProperty("line.separator");
    static final String FSEP = System.getProperty("file.separator");

    public static PluggableTaskUtil createPluggableTaskUtil(boolean darwin) {
        if (darwin) {
            return new DarwinPluggableTaskUtil();
        }
        return new PluggableTaskUtil();
    }

    public ResultSet execVerificationExecutable(String[] nodeList, ExecutableInfo execInfo) throws VerificationExecutableException {
        Trace.out((String)"Starting execVerificationExecutable...");
        ResultSet resultSet = PluggableTaskUtil.execExecutable(nodeList, execInfo);
        return resultSet;
    }

    static ResultSet execExecutable(String[] nodeList, ExecutableInfo execInfo) throws VerificationExecutableException {
        Trace.out((String)"Starting execExecutable...");
        int numOfNodes = nodeList.length;
        String delim = " ";
        ResultSet resultSet = new ResultSet();
        if (execInfo.getExecutableType().equals((Object)ExecutableType.SQL)) {
            resultSet = PluggableTaskUtil.executeSQL(execInfo);
        } else {
            Command[] cmdList = new Command[numOfNodes];
            String command = null;
            Object executableArgs = null;
            Object execArgs = null;
            if (execInfo.getExecutableName() != null) {
                command = execInfo.getExecutableNameWithPath();
                Trace.out((String)("Command: " + command));
                if (!new File(command).exists()) {
                    Trace.out((String)("Command '" + command + "' does not exist"));
                    throw new VerificationExecutableException(s_msgBundle.getMessage("0007", false, (Object[])new String[]{command}));
                }
            } else {
                Trace.out((String)"Command not available with ExecuteInfo");
                throw new VerificationExecutableException(s_msgBundle.getMessage("0008", false));
            }
            StringBuilder commandLine = new StringBuilder();
            commandLine.append(command);
            List<ExecutableArgument> argList = execInfo.getExecutableArgs();
            for (ExecutableArgument eArg : argList) {
                String argVal = eArg.getArgVal();
                if (argVal == null || argVal.length() == 0) {
                    throw new VerificationExecutableException(s_msgBundle.getMessage("0018", false));
                }
                if (eArg.getArgType() == ArgType.DERIVED && ((argVal = VerificationUtil.getVariableValue(argVal)) == null || argVal.length() == 0)) {
                    throw new VerificationExecutableException(s_msgBundle.getMessage("0009", false, (Object[])new String[]{argVal}));
                }
                commandLine.append(" " + argVal);
            }
            for (int i = 0; i < numOfNodes; ++i) {
                cmdList[i] = new RunExeCommand(nodeList[i], commandLine.toString(), false);
            }
            new GlobalHandler().submit(cmdList, 0, resultSet);
            Hashtable ht = resultSet.getResultTable();
            Enumeration e = ht.keys();
            ResultSet rSet = new ResultSet();
            for (int i = 0; i < numOfNodes; ++i) {
                String node = cmdList[i].getNode();
                String[] rsltStr = cmdList[i].getCommandResult().getResultString();
                String reoutput = VerificationUtil.strArr2List(rsltStr, LSEP);
                Result tempRes = (Result)ht.get(node);
                tempRes.addResultInfo(reoutput);
                rSet.addResult(node, tempRes);
            }
            resultSet = PluggableTaskUtil.mapResultSet(rSet);
        }
        return resultSet;
    }

    private static ResultSet executeSQL(ExecutableInfo execInfo) {
        String dbName = null;
        String dbDescr = null;
        String dbUser = null;
        String dbPwd = null;
        for (ExecutableArgument arg : execInfo.getExecutableArgs()) {
            String argName = arg.getArgName();
            String argVal = arg.getArgVal();
            if ("DB_NAME".equals(argName)) {
                dbName = argVal;
                continue;
            }
            if ("DB_DESCR".equals(argName)) {
                dbDescr = argVal;
                continue;
            }
            if ("DB_USER".equals(argName)) {
                dbUser = argVal;
                continue;
            }
            if ("DB_PWD".equals(argName)) {
                dbPwd = argVal;
                continue;
            }
            Trace.out((String)("unknown argument. namer=" + argName + ". value=" + argVal));
        }
        ResultSet rsltSet = new ResultSet();
        Result dbRes = new Result(dbName);
        rsltSet.addResult(dbName, dbRes);
        try {
            OracleConnection connection = SQLFactory.getDBConnection(dbDescr, dbUser, dbPwd);
            Statement st = connection.createStatement();
            String query = execInfo.getExecutableName();
            Trace.out((String)("executing query: " + query));
            java.sql.ResultSet rs = st.executeQuery(query);
            OracleCachedRowSet rowSet = new OracleCachedRowSet();
            rowSet.populate(rs);
            dbRes.addResultInfo(rowSet);
            rsltSet.addResult(dbName, 1);
            rsltSet.setStatus(1);
            rs.close();
            st.close();
            connection.close();
        }
        catch (DBConnectionException e) {
            rsltSet.addResult(dbName, 2);
            rsltSet.addErrorDescription(dbName, new ErrorDescription(e.getMessage()));
            Trace.out((String)("DBConnectionException occured. message:" + e.getMessage()));
            Trace.out((Exception)((Object)e));
        }
        catch (SQLException e) {
            rsltSet.addResult(dbName, 2);
            rsltSet.addErrorDescription(dbName, new ErrorDescription(e.getMessage()));
            Trace.out((String)("SQLException occured. message:" + e.getMessage()));
        }
        return rsltSet;
    }

    static ResultSet mapResultSet(ResultSet resultSet) {
        Trace.out((String)"Starting mapResultSet...");
        Hashtable ht = resultSet.getResultTable();
        Enumeration e = ht.keys();
        boolean i = false;
        ResultSet rsltSet = new ResultSet();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            String vfRslt = (String)result.getResultInfoSet().lastElement();
            String resultSetString = VerificationUtil.fetchTextByTags(vfRslt, "<RESULTSET>", "</RESULTSET>");
            if (VerificationUtil.isStringGood(resultSetString)) {
                String[] resultStringArray;
                for (String resultString : resultStringArray = VerificationUtil.fetchTextByTagsRepeat(resultSetString, "<RESULT>", "</RESULT>")) {
                    String rowIdStr = VerificationUtil.fetchTextByTags(resultSetString, "<ROW_ID>", "</ROW_ID>");
                    if (VerificationUtil.isStringGood(rowIdStr)) {
                        node = rowIdStr;
                    }
                    result = PluggableTaskUtil.mapResult(node, resultString, resultSet);
                    rsltSet.addResult(result.getNode(), result);
                }
                continue;
            }
            result = PluggableTaskUtil.mapResult(node, vfRslt, resultSet);
            rsltSet.addResult(result.getNode(), result);
        }
        return rsltSet;
    }

    private static Result mapResult(String node, String vfRslt, ResultSet rsltSet) {
        String execResult = new String();
        String execStatus = new String();
        String expectedVal = new String();
        String collectedVal = new String();
        String execErr = new String();
        String nlsMsg = null;
        String facility = null;
        String idStr = null;
        String msgData = null;
        Object[] data = null;
        String traceMsg = null;
        String global_err = null;
        String rowIdStr = null;
        String resultId = null;
        boolean displayFac = true;
        execStatus = VerificationUtil.fetchTextByTags(vfRslt, "<STATUS>", "</STATUS>");
        execResult = VerificationUtil.fetchTextByTags(vfRslt, "<RESULT>", "</RESULT>");
        expectedVal = VerificationUtil.fetchTextByTags(vfRslt, "<EXPECTED>", "</EXPECTED>");
        collectedVal = VerificationUtil.fetchTextByTags(vfRslt, "<COLLECTED>", "</COLLECTED>");
        execErr = VerificationUtil.fetchTextByTags(vfRslt, "<EXEC_ERROR>", "</EXEC_ERROR>");
        global_err = VerificationUtil.fetchTextByTags(vfRslt, "<GLOBAL_ERROR>", "</GLOBAL_ERROR>");
        nlsMsg = VerificationUtil.fetchTextByTags(vfRslt, "<NLS_MSG>", "</NLS_MSG>");
        rowIdStr = VerificationUtil.fetchTextByTags(vfRslt, "<ROW_ID>", "</ROW_ID>");
        if (VerificationUtil.isStringGood(execStatus)) {
            execResult = execStatus;
        }
        resultId = VerificationUtil.isStringGood(rowIdStr) ? rowIdStr : node;
        Result result = new Result(resultId);
        if (execResult != null) {
            if (execResult.equalsIgnoreCase("SUCC")) {
                result.setStatus(1);
                displayFac = false;
            } else if (execResult.equalsIgnoreCase("WARN")) {
                result.setStatus(4);
                displayFac = false;
            } else if (execResult.equalsIgnoreCase("VFAIL")) {
                result.setStatus(3);
            } else if (execResult.equalsIgnoreCase("EFAIL")) {
                result.setStatus(2);
            } else {
                result.setStatus(5);
            }
        } else {
            Trace.out((String)"<RESULT> tags contain empty string.");
            result.addErrorInfo(s_msgBundle.getMessage("0010", false, (Object[])new String[]{vfRslt}));
            result.setStatus(5);
        }
        facility = null;
        idStr = null;
        msgData = null;
        traceMsg = null;
        if (nlsMsg != null) {
            facility = VerificationUtil.fetchTextByTags(vfRslt, "<FACILITY>", "</FACILITY>");
            idStr = VerificationUtil.fetchTextByTags(vfRslt, "<ID>", "</ID>");
            msgData = VerificationUtil.fetchTextByTags(vfRslt, "<MSG_DATA>", "</MSG_DATA>");
            if (msgData != null) {
                data = VerificationUtil.fetchTextByTagsRepeat(msgData, "<DATA>", "</DATA>");
            }
            Trace.out((String)("facility=" + facility + " ; idStr=" + idStr + " ; data=" + data));
            if (facility != null && idStr != null) {
                MessageBundle msgBundle = VerificationUtil.getMessageBundle(facility);
                if (msgBundle != null) {
                    String errMsg = data != null && data.length >= 1 ? msgBundle.getMessage(idStr, displayFac, data) : msgBundle.getMessage(idStr, displayFac);
                    if (displayFac) {
                        String cause = msgBundle.getCause(idStr, false);
                        String action = msgBundle.getAction(idStr, false);
                        Trace.out((String)("errMsg=" + errMsg + LSEP + "cause=" + cause + LSEP + "action=" + action));
                        ErrorDescription errDesc = new ErrorDescription(errMsg, cause, action);
                        if (global_err != null && global_err.length() > 1) {
                            rsltSet.addErrorDescription(errDesc);
                        } else {
                            result.addErrorDescription(errDesc);
                        }
                    } else {
                        VerificationMessage vfyMsg = new VerificationMessage(VerificationMessageType.VERBOSE, errMsg);
                        if (global_err != null && global_err.length() > 1) {
                            rsltSet.addVerificationMessage(vfyMsg);
                        } else {
                            result.addVerificationMessage(vfyMsg);
                        }
                    }
                } else {
                    Trace.out((String)("Couldn't get message bundle for facility: '" + facility + "'"));
                    String errMsg = s_msgBundle.getMessage("0015", false, (Object[])new String[]{facility});
                    String cause = msgBundle.getCause("0015", false);
                    String action = msgBundle.getAction("0015", false);
                    ErrorDescription errDesc = new ErrorDescription(errMsg, cause, action);
                    if (global_err != null && global_err.length() > 1) {
                        rsltSet.addErrorDescription(errDesc);
                    } else {
                        result.addErrorDescription(errDesc);
                    }
                }
            }
        }
        traceMsg = VerificationUtil.fetchTextByTags(vfRslt, "<TRACE>", "</TRACE>");
        if (expectedVal != null) {
            result.setHasResultValues(true);
            result.setExpectedValue(expectedVal);
        }
        if (collectedVal != null) {
            result.setHasResultValues(true);
            result.setActualValue(collectedVal);
        }
        if (execErr != null) {
            result.addErrorInfo(execErr);
        }
        if (traceMsg != null) {
            result.addTraceInfo(traceMsg);
        }
        result.addResultInfo(vfRslt);
        Trace.out((String)("output " + execResult));
        Trace.out((String)("expectedVal " + expectedVal));
        Trace.out((String)("collecetdVal " + collectedVal));
        Trace.out((String)("execError " + execErr));
        Trace.out((String)("Trace " + traceMsg));
        Trace.out((String)("nlsMsg " + nlsMsg));
        return result;
    }

    public static boolean cleanUp(String[] node, String dirPath, boolean isRecurse) {
        ClusterCmd cmd = new ClusterCmd();
        boolean ret = true;
        try {
            if (new File(dirPath).exists()) {
                cmd.removeDirectory(node, dirPath, isRecurse);
            }
        }
        catch (ClusterException ce) {
            ret = false;
            Trace.out((String)ce.getMessage());
        }
        return ret;
    }

    public String getPluggableMsg(PluggableMsgType msgType, String taskID, String[] msgParams) {
        String msgStr = "";
        try {
            String fieldName = msgType.getMsgIDExtn() + "_" + taskID;
            Class<?> c = Class.forName("oracle.ops.verification.resources.PrveMsgID");
            Field f = c.getField(fieldName);
            msgStr = s_msgBundle.getMessage((String)f.get(new GetPrveMsgID()), false, (Object[])msgParams);
        }
        catch (ClassNotFoundException e) {
            Trace.out((String)("ClassNotFoundException encountered:" + e));
        }
        catch (NoSuchFieldException e) {
            Trace.out((String)("NoSuchFieldException encountered:" + e));
        }
        catch (IllegalAccessException e) {
            Trace.out((String)("IllegalAccessException encountered:" + e));
        }
        return msgStr;
    }

    public String getPluggableMsg(PluggableMsgType msgType, String taskID) {
        return this.getPluggableMsg(msgType, taskID, null);
    }

    private class GetPrveMsgID
    implements PrveMsgID {
        private GetPrveMsgID() {
        }
    }
}

